class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Computer Active'
    oldest_article = 7
    max_articles_per_feed = 100
    summary_length         = 100
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    
    keep_only_tags = [dict(name='div',attrs={'id':'container'})]
    remove_attributes = ['style', 'font']
    remove_tags = [dict(name='div', attrs={'class':['shopping_deals','section_title','article_tags_block','section_title title_right_button_fix','add_comment_block','related_article_block_parent image_fix_105_block','common_left_block dynamic_disp','small_section','article_related_links','recent_comment_block_parent','common_button align_right for_grey']}),
                   dict(name='div', attrs={'id':['container_right','wrapperfooter',]}),
                   dict(name='p', attrs={'class':['article_links']}),
                   dict(name='img'),]

    feeds          = [
                       (u'General content', u'http://feeds.computeractive.co.uk/rss/latest/computeractive/all'),
                       (u'News', u'http://feeds.computeractive.co.uk/rss/latest/computeractive/news'),
                       (u'Downloads', u'http://feeds.computeractive.co.uk/rss/latest/computeractive/downloads'),
                       (u'Hardware', u'http://feeds.computeractive.co.uk/rss/latest/computeractive/hardware'),
                       (u'Software', u'http://feeds.computeractive.co.uk/rss/latest/computeractive/software')   
                     ]
						  
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
